TITLE   'Poisson Equation'						    { apx2.pde }
SELECT   errlim=1e-15   nodelimit=10      	
VARIABLES     u
DEFINITIONS
  Lx=1     Ly=1     u_ex=y^2* sin(x)
EQUATIONS
   del2(u)= -(y^2-2)*sin(x)
BOUNDARIES
region 'domain' start 'outer'  (0,0)  value(u)=u_ex
   line to (Lx,0) to (Lx,Ly) to (0,Ly) to finish
PLOTS
   grid( x,y) zoom(0,0,  0.3,0.3)
   contour( u-u_ex)  zoom(0,0,  0.3,0.3)  fixed range(-1e-8, 1e-8)
END


